<?php

namespace Core\Contract\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Common\Resources\CityResource;
use Core\Provider\Resources\TruckTypeResource;
use Core\Shipment\Resources\ShipmentTypeResource;
class ContractItemResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();
        return [
            'id'   => $this->id,
            'contract_id' => $this->contract_id,
            'from_city_id' => $this->from_city_id,
            'to_city_id' => $this->to_city_id,
            'truck_type_id' => $this->truck_type_id,
            'shipment_type_id' => $this->shipment_type_id,
            'price' => $this->price,
            $this->mergeWhen($route_name == 'api.v1.contract_items.show' || $route_name == 'api.v1.contracts.show', [
                'from_city'     => new CityResource($this->fromCity),
                'to_city'       => new CityResource($this->toCity),
                'truck_type'    => new TruckTypeResource($this->truckType),
                'shipment_type' => new ShipmentTypeResource($this->shipmentType),
            ]),
            $this->mergeWhen($route_name == 'api.v1.contract_items.show', [
                'contract' => new ContractResource($this->contract)
            ])
        ];
    }
}
