<?php

namespace Core\Contract\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ContractRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'contractable_type' => 'string|required|in:shipper,provider',
                    'contractable_id' => 'integer|required',
                    'payment_terms' => 'integer|nullable',
                ];
            }
            case 'PUT': {
                return [
                    'contractable_type' => 'string|nullable|in:shipper,provider',
                    'contractable_id' => 'integer|nullable',
                    'payment_terms' => 'integer|nullable',
                ];
            }
        }
    }
}
