<?php

namespace Core\Contract\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ContractItemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'contract_id' => 'required',
                    'from_city_id' => 'required',
                    'to_city_id' => 'required',
                    'truck_type_id' => 'required',
                    'shipment_type_id' => 'required',
                    'price' => 'numeric|required',
                ];
            }
            case 'PUT': {
                return [
                    'contract_id' => 'nullable',
                    'from_city_id' => 'nullable',
                    'to_city_id' => 'nullable',
                    'truck_type_id' => 'nullable',
                    'shipment_type_id' => 'nullable',
                    'price' => 'numeric|nullable',
                ];
            }
        }
    }
}
