<?php

namespace Core\Contract\Observers;

use Core\Contract\Models\Contract;
use Core\Financial\Jobs\InvoiceCollection;
use Core\Financial\Jobs\RequestCollection;

class ContractObserver
{
    /**
     * Handle the Contract "created" event.
     *
     * @param  \Core\Contract\Models\Contract  $contract
     * @return void
     */
    public function created(Contract $contract)
    {
        if($contract->contractable_type == 'shipper') {
            InvoiceCollection::dispatch($contract)->delay(now()->addDays($contract->payment_terms));
        }

        if($contract->contractable_type == 'provider') {
            RequestCollection::dispatch($contract)->delay(now()->addDays($contract->payment_terms));
        }
    }
}
