<?php

namespace Core\Contract\Models;

use Core\Base\Models\Base;

class ContractItem extends Base
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'contract_items';

    /**
     * get the contract.
     */
    public function contract()
    {
        return $this->belongsTo(Contract::class, 'contract_id');
    }

    /**
     * get from city.
     */
    public function fromCity()
    {
        return $this->belongsTo(\Core\Common\Models\City::class, 'from_city_id');
    }

    /**
     * get to city.
     */
    public function toCity()
    {
        return $this->belongsTo(\Core\Common\Models\City::class, 'to_city_id');
    }

    /**
     * get the truck type.
     */
    public function truckType()
    {
        return $this->belongsTo(\Core\Provider\Models\TruckType::class, 'truck_type_id');
    }

    /**
     * get the shipment type.
     */
    public function shipmentType()
    {
        return $this->belongsTo(\Core\Shipment\Models\ShipmentType::class, 'shipment_type_id');
    }
}
