<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContractItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contract_items', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->foreignId('contract_id');
            $table->foreign('contract_id')->references('id')->on('contracts')->onDelete('cascade');

            $table->foreignId('from_city_id');
            $table->foreign('from_city_id')->references('id')->on('cities')->onDelete('cascade');

            $table->foreignId('to_city_id');
            $table->foreign('to_city_id')->references('id')->on('cities')->onDelete('cascade');

            $table->foreignId('truck_type_id');
            $table->foreign('truck_type_id')->references('id')->on('truck_types')->onDelete('cascade');

            $table->foreignId('shipment_type_id');
            $table->foreign('shipment_type_id')->references('id')->on('shipment_types')->onDelete('cascade');

            $table->decimal('price', 9, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contract_items');
    }
}
