<?php

namespace Core\Contract\Database\Factories;

use Core\Contract\Models\ContractItem as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class ContractItemFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $contract      = \Core\Contract\Models\Contract::factory()->create();
        $from_city     = \Core\Common\Models\City::factory()->create();
        $to_city       = \Core\Common\Models\City::factory()->create();
        $truck_type    = \Core\Provider\Models\TruckType::factory()->create();
        $shipment_type = \Core\Shipment\Models\ShipmentType::factory()->create();
        
        return [
            'contract_id'      => $contract->id,
            'from_city_id'     => $from_city->id,
            'to_city_id'       => $to_city->id,
            'truck_type_id'    => $truck_type->id,
            'shipment_type_id' => $shipment_type->id,
            'price'            => $this->faker->randomFloat(),
        ];
    }
}
