<?php

namespace Core\Contract\Database\Factories;

use Core\Contract\Models\Contract as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class ContractFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'contractable_type' => $this->faker->randomElement(['shipper', 'provider']),
            'contractable_id'   => $this->faker->randomDigit(),
        ];
    }
}
