<?php

namespace Core\Common\SmsGateways;

use GuzzleHttp\Client;

class Unifonic
{
    /**
     * http client.
     *
     * @var \GuzzleHttp\Client
     */
    protected $client;

    /**
     * the payload.
     *
     * @var array
     */
    protected $payload;

    /**
     * the endpoint.
     *
     * @var string
     */
    protected $endpoint = 'rest/SMS/messages';

    /**
     * init.
     *
     * @param  array $payload
     * @return void
     */
    public function __construct(array $payload)
    {
        $this->client = new Client([
            'base_uri' => $this->config()['base_url'] . '/',
            'headers'  => [
                'Content-Type' => 'application/json',
                'Accept'       => 'application/json'
            ]
        ]);

        $current_payload = [
            'AppSid'   => $this->config()['app_sid'],
            'SenderID' => $this->config()['sender_id']
        ];

        $this->payload = array_merge($payload, $current_payload);
    }

    /**
     * get the configuration
     * 
     * @return array
     */
    protected function config()
    {
        return config('core_common.sms.gateways.unifonic');
    }

    /**
     * send text messages
     *
     * @return array
     */
    public function sendMessage()
    {
        $request = $this->client->post($this->endpoint, [
            'json' => $this->payload
        ]);

        $response = json_decode($request->getBody());

        logger()->channel('sms-gateways')->info(json_encode($response));

        return (array) $response;
    }
}