<?php

namespace Core\Common\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class StateResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $route_name = $request->route()->getName();

        return [
            'id'   => $this->id,
            'name' => $this->name,
            'country_id' => $this->country_id,
            'fips_code' => $this->fips_code,
            'iso2' => $this->iso2,
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,
            $this->mergeWhen($route_name == 'api.v1.states.show', [
                'country' => new CountryResource($this->country)
            ]),
            $this->mergeWhen($route_name == 'api.v1.states.show' || request()->cities, [
                'cities'  => CityResource::collection($this->cities)
            ])
        ];
    }
}
