<?php

namespace Core\Common\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class PhoneResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'             => $this->id,
            'phoneable_type' => $this->phoneable_type,
            'phoneable_id'   => $this->phoneable_id,
            'type'           => $this->type,
            'phone'          => $this->phone,
            'name'           => $this->name,
            $this->mergeWhen($request->route()->getName() == 'api.v1.phones.show', [
                'phoneable' => $this->phoneable
            ])
        ];
    }
}
