<?php

namespace Core\Common\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class CountryResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'              => $this->id,
            'name'            => $this->name,
            'iso3'            => $this->iso3,
            'iso2'            => $this->iso2,
            'phonecode'       => $this->phonecode,
            'capital'         => $this->capital,
            'currency'        => $this->currency,
            'currency_symbol' => $this->currency_symbol,
            'tld'             => $this->tld,
            'native'          => $this->native,
            'region'          => $this->region,
            'subregion'       => $this->subregion,
            'timezones'       => $this->timezones,
            'translations'    => $this->translations,
            'latitude'        => $this->latitude,
            'longitude'       => $this->longitude,
            $this->mergeWhen($request->route()->getName() == 'api.v1.countries.show', [
                'states' => StateResource::collection($this->states)
            ])
        ];
    }
}
