<?php

namespace Core\Common\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class CompanyResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'   => $this->id,
            'companyable_type' => $this->companyable_type,
            'companyable_id' => $this->companyable_id,
            'name' => $this->name,
            'logo' => $this->logo,
            'cr_no' => $this->cr_no,
            'vat_registration_no' => $this->vat_registration_no,
            'cr_copy' => $this->cr_copy,
            'vat_certificate_copy' => $this->vat_certificate_copy,
            'building_no' => $this->building_no,
            'street_name' => $this->street_name,
            'district_name' => $this->district_name,
            'city_name' => $this->city_name,
            'zip_code' => $this->zip_code,
            'additional_number' => $this->additional_number,
            'unit_number' => $this->unit_number,
            'iban_no' => $this->iban_no,
            'bank_name' => $this->bank_name,
            'iban_certificate' => $this->iban_certificate,
            $this->mergeWhen($request->route()->getName() == 'api.v1.companies.show', [
                'companyable' => $this->companyable
            ])
        ];
    }
}
