<?php

namespace Core\Common\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Contract\Resources\ContractItemResource;
use Core\Shipment\Resources\ShipmentResource;

class CityResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'        => $this->id,
            'name'      => $this->name,
            'name_ar'   => $this->name_ar,
            'latitude'  => $this->latitude,
            'longitude' => $this->longitude,
            $this->mergeWhen($request->route()->getName() == 'api.v1.cities.show', [
                'state'               => new StateResource($this->state),
                'addresses'           => AddressResource::collection($this->addresses),
                'contract_items_from' => ContractItemResource::collection($this->contractItemsFrom),
                'contract_items_to'   => ContractItemResource::collection($this->contractItemsTo),
                'shipments_from'      => ShipmentResource::collection($this->shipmentsFrom),
                'shipments_to'        => ShipmentResource::collection($this->shipmentsTo)
            ])
        ];
    }
}
