<?php

namespace Core\Common\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;

class AttachmentResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'   => $this->id,
            'attachmentable_type' => $this->attachmentable_type,
            'attachmentable_id' => $this->attachmentable_id,
            'label' => $this->label,
            'path' => $this->path,
            'details' => $this->details,
            $this->mergeWhen($request->route()->getName() == 'api.v1.attachments.show', [
                'attachmentable' => $this->attachmentable
            ])
        ];
    }
}
