<?php

namespace Core\Common\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Provider\Resources\ProviderResource;
use Core\Shipper\Resources\GroupResource;
use Core\Shipment\Resources\OrderResource;

class AddressResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'        => $this->id,
            'name'      => $this->name,
            'type'      => $this->type,
            'address'   => $this->address,
            'latitude'  => $this->latitude,
            'longitude' => $this->longitude,
            $this->mergeWhen($request->route()->getName() != 'api.v1.cities.show', [
                'city' => new CityResource($this->city)
            ]),
            $this->mergeWhen($request->route()->getName() != 'api.v1.phones.show', [
                'phones' => PhoneResource::collection($this->phones)
            ]),
            $this->mergeWhen($request->route()->getName() == 'api.v1.addresses.show', [
                'provider'       => $this->when($this->addressable_type == 'provider', new ProviderResource($this->addressable)),
                'group'          => $this->when($this->addressable_type == 'group', new GroupResource($this->addressable)),
                'pickup_orders'  => OrderResource::collection($this->pickupOrders),
                'dropoff_orders' => OrderResource::collection($this->dropoffOrders)
            ])
        ];
    }
}
