<?php

namespace Core\Common\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PhoneRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function store($prefix = '')
    {
        return [
            $prefix . 'phoneable_type' => 'string|required|in:address,group,shipper,provider,driver',
            $prefix . 'phoneable_id'   => 'integer|required',
            $prefix . 'type'           => 'string|nullable',
            $prefix . 'phone'          => 'string|required',
            $prefix . 'name'           => 'string|nullable',
        ];
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function update($prefix = '')
    {
        return [
            $prefix . 'phoneable_type' => 'string|nullable|in:address,group,shipper,provider,driver',
            $prefix . 'phoneable_id'   => 'integer|nullable',
            $prefix . 'type'           => 'string|nullable',
            $prefix . 'phone'          => 'string|nullable',
            $prefix . 'name'           => 'string|nullable',
        ];
    }
}
