<?php

namespace Core\Common\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CountryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'name' => 'string|required',
                    'iso3' => 'string|nullable',
                    'iso2' => 'string|nullable',
                    'phonecode' => 'string|nullable',
                    'capital' => 'string|nullable',
                    'currency' => 'string|nullable',
                    'currency_symbol' => 'string|nullable',
                    'tld' => 'string|nullable',
                    'native' => 'string|nullable',
                    'region' => 'string|nullable',
                    'subregion' => 'string|nullable',
                    'timezones' => 'nullable',
                    'translations' => 'nullable',
                    'latitude' => 'numeric|nullable',
                    'longitude' => 'numeric|nullable',
                ];
            }
            case 'PUT': {
                return [
                    'name' => 'string|nullable',
                    'iso3' => 'string|nullable',
                    'iso2' => 'string|nullable',
                    'phonecode' => 'string|nullable',
                    'capital' => 'string|nullable',
                    'currency' => 'string|nullable',
                    'currency_symbol' => 'string|nullable',
                    'tld' => 'string|nullable',
                    'native' => 'string|nullable',
                    'region' => 'string|nullable',
                    'subregion' => 'string|nullable',
                    'timezones' => 'nullable',
                    'translations' => 'nullable',
                    'latitude' => 'numeric|nullable',
                    'longitude' => 'numeric|nullable',
                ];
            }
        }
    }
}
