<?php

namespace Core\Common\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CompanyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function store($prefix = '')
    {
        return [
            $prefix . 'companyable_type' => 'string|required',
            $prefix . 'companyable_id' => 'integer|required',
            $prefix . 'name' => 'string|nullable',
            $prefix . 'logo' => 'image|nullable',
            $prefix . 'cr_no' => 'string|nullable',
            $prefix . 'vat_registration_no' => 'string|nullable',
            $prefix . 'cr_copy' => 'file|nullable',
            $prefix . 'vat_certificate_copy' => 'file|nullable',
            $prefix . 'building_no' => 'string|nullable',
            $prefix . 'street_name' => 'string|nullable',
            $prefix . 'district_name' => 'string|nullable',
            $prefix . 'city_name' => 'string|nullable',
            $prefix . 'zip_code' => 'string|nullable',
            $prefix . 'additional_number' => 'string|nullable',
            $prefix . 'unit_number' => 'string|nullable',
            $prefix . 'iban_no' => 'string|nullable',
            $prefix . 'bank_name' => 'string|nullable',
            $prefix . 'iban_certificate' => 'file|nullable',
        ];
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function update($prefix = '')
    {
        return [
            $prefix . 'companyable_type' => 'string|required',
            $prefix . 'companyable_id' => 'integer|required',
            $prefix . 'name' => 'string|nullable',
            $prefix . 'logo' => 'nullable',
            $prefix . 'cr_no' => 'string|nullable',
            $prefix . 'vat_registration_no' => 'string|nullable',
            $prefix . 'cr_copy' => 'nullable',
            $prefix . 'vat_certificate_copy' => 'nullable',
            $prefix . 'building_no' => 'string|nullable',
            $prefix . 'street_name' => 'string|nullable',
            $prefix . 'district_name' => 'string|nullable',
            $prefix . 'city_name' => 'string|nullable',
            $prefix . 'zip_code' => 'string|nullable',
            $prefix . 'additional_number' => 'string|nullable',
            $prefix . 'unit_number' => 'string|nullable',
            $prefix . 'iban_no' => 'string|nullable',
            $prefix . 'bank_name' => 'string|nullable',
            $prefix . 'iban_certificate' => 'nullable',
        ];
    }
}
