<?php

namespace Core\Common\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CityRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'state_id' => 'required',
                    'name' => 'string|required',
                    'name_ar' => 'string|nullable',
                    'latitude' => 'numeric|nullable',
                    'longitude' => 'numeric|nullable',
                ];
            }
            case 'PUT': {
                return [
                    'state_id' => 'nullable',
                    'name' => 'string|nullable',
                    'name_ar' => 'string|nullable',
                    'latitude' => 'numeric|nullable',
                    'longitude' => 'numeric|nullable',
                ];
            }
        }
    }
}
