<?php

namespace Core\Common\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AttachmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return [
                    'attachmentable_type' => 'string|nullable',
                    'attachmentable_id' => 'integer|nullable',
                    'label' => 'string|nullable',
                    'path' => 'string|required',
                    'details' => 'nullable',

                ];
            }
            case 'PUT': {
                return [
                    'attachmentable_type' => 'string|nullable',
                    'attachmentable_id' => 'integer|nullable',
                    'label' => 'string|nullable',
                    'path' => 'string|required',
                    'details' => 'nullable',

                ];
            }
        }
    }
}
