<?php

namespace Core\Common\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddressRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function store($prefix = '')
    {
        $array = [
            'addressable_type' => 'string|required|in:group,shipper,provider,driver',
            'addressable_id' => 'integer|required',
            'city_id' => 'required',
            'name' => 'string|nullable',
            'type' => 'string|nullable',
            'address' => 'nullable',
            'latitude' => 'numeric|nullable',
            'longitude' => 'numeric|nullable',
            'phones' => 'required|array',
        ];

        $rules = array_merge($array, PhoneRequest::store('phones.*.'));

        $rules['phones.*.phoneable_type'] = '';
        $rules['phones.*.phoneable_id']   = '';

        return $rules;
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @param  string $prefix
     * @return array
     */
    public static function update($prefix = '')
    {
        $array = [
            'addressable_type' => 'string|required|in:group,shipper,provider,driver',
            'addressable_id' => 'integer|nullable',
            'city_id' => 'nullable',
            'name' => 'string|nullable',
            'type' => 'string|nullable',
            'address' => 'nullable',
            'latitude' => 'numeric|nullable',
            'longitude' => 'numeric|nullable',
            'phones' => 'nullable|array',
        ];

        $rules = array_merge($array, PhoneRequest::update('phones.*.'));

        $rules['phones.*.phoneable_type'] = '';
        $rules['phones.*.phoneable_id']   = '';

        return $rules;
    }
}
