<?php

namespace Core\Common\Observers;

use Core\Common\Models\Address;

class AddressObserver
{
    /**
     * Handle the Address "created" event.
     *
     * @param  \Core\Common\Models\Address  $address
     * @return void
     */
    public function created(Address $address)
    {
        if ($this->routeName() == 'api.v1.addresses.store') {
            $address->phones()->createMany(request()->phones);
        }
    }

    /**
     * Get the current route name.
     *
     * @return string
     */
    protected function routeName()
    {
        return request()->route() ? request()->route()->getName() : '';
    }
}
