<?php

namespace Core\Common\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification as Base;
use NotificationChannels\Fcm\FcmChannel;
use NotificationChannels\Fcm\FcmMessage;
use Core\Common\SmsGateways\Unifonic;

class Notification extends Base
{
    use Queueable;

    /**
     * data
     * 
     * @var array
     */
    protected $data = [
        'title'                 => '',
        'body'                  => '',
        'notificationable_type' => '',
        'payload'               => []
    ];

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        // return [FcmChannel::class, 'database'];
        return ['database'];
    }

    /**
     * Get the FCM representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \NotificationChannels\Fcm\FcmMessage
     */
    public function toFcm($notifiable)
    {
        return FcmMessage::create()
            ->setData($this->data)
            ->setNotification(\NotificationChannels\Fcm\Resources\Notification::create()
                ->setTitle($this->data['title'])
                ->setBody($this->data['body']));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        // send FCM (not the best place but due to the fcm channel is not working properly)
        if ($notifiable->fcm_tokens) {
            $fcm_payload = [
                'notification' => [
                    'title' => $this->data['title'],
                    'body'  => $this->data['body']
                ],
                'data'             => $this->data,
                'registration_ids' => $notifiable->fcm_tokens
            ];
    
            $fcm = new FCM($fcm_payload);
            $fcm->send();
        }


        // send SMS (not the best place but there is no channel for the current SMS Gateway)
        if ($notifiable->receive_sms_notifications && $notifiable->phone) {
            $payload = [
                'Body'      => $this->data['body'],
                'Recipient' => $notifiable->phone,
                'async'     => true
            ];

            $unifonic = new Unifonic($payload);
            $unifonic->sendMessage();
        }

        return $this->data;
    }

    /**
     * send FCM Notification (Cloud Messaging API (Legacy))
     * 
     */
    public static function sendFcmNotification($registration_ids, $title, $message, $data, $img = '')
    {
        $msg = urlencode($message);

        $payload = [
            'title' => $title,
            'sound' => 'default',
            'msg'   => $msg,
            'data'  => $data,
            'body'  => $message,
            'color' => '#79bc64'
        ];

        if($img){
            $payload['image']   = $img;
            $payload['style']   = 'picture';
            $payload['picture'] = $img;
        }

        $fields = [
            'registration_ids' => $registration_ids,
            'notification'     => $payload,
            'data'             => $data,
            'priority'         => 'high',
        ];

        $headers = [
            'Authorization: key=' . env('FIREBASE_SERVER_KEY'),
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result = curl_exec($ch);
        curl_close($ch);

        return $result;
    }
}
