<?php

namespace Core\Common\Notifications;

use GuzzleHttp\Client;

class FCM
{
    /**
     * http client.
     *
     * @var \GuzzleHttp\Client
     */
    protected $client;

    /**
     * the payload.
     *
     * @var array
     */
    protected $payload;

    /**
     * the endpoint.
     *
     * @var string
     */
    protected $endpoint = 'fcm/send';

    /**
     * init.
     *
     * @param  array $payload
     * @return void
     */
    public function __construct(array $payload)
    {
        $this->client = new Client([
            'base_uri' => 'https://fcm.googleapis.com' . '/',
            'headers'  => [
                'Content-Type'  => 'application/json',
                'Accept'        => 'application/json',
                'Authorization' => 'key=' . env('FIREBASE_SERVER_KEY')
            ]
        ]);

        $this->payload = $payload;
    }

    /**
     * send FCM Notification (Cloud Messaging API (Legacy))
     *
     * @return array
     */
    public function send()
    {
        $request = $this->client->post($this->endpoint, [
            'json' => $this->payload
        ]);

        $response = json_decode($request->getBody());

        logger()->channel('realtime-notifications')->info(json_encode($response));

        return (array) $response;
    }
}