<?php

namespace Core\Common;

use Illuminate\Support\ServiceProvider;
use Core\Base\Traits\ServiceProvider\File;
use Illuminate\Database\Eloquent\Relations\Relation;

class ModuleServiceProvider extends ServiceProvider
{
    use File;

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->loadFiles(__DIR__, 'common');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        Relation::enforceMorphMap([
            'address'    => Models\Address::class,
            'attachment' => Models\Attachment::class,
            'city'       => Models\City::class,
            'country'    => Models\Country::class,
            'state'      => Models\State::class,
            'phone'      => Models\Phone::class,
            'company'    => Models\Company::class,
        ]);

        Models\Address::observe(Observers\AddressObserver::class);
    }
}
