<?php
 
namespace Core\Common\Models\Scopes;
 
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;
use Core\Common\Models\Address;
 
class RelatedAddressesScope implements Scope
{
    /**
     * Apply the scope to a given Eloquent query builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        if (request()->getMethod() == 'GET' && !request()->group) {
            $shipper = null;

            if (auth()->user() && auth()->user()->userable_type == 'shipper') {
                $shipper = auth()->user()->userable;
            } elseif (request()->shipper_id) {
                $shipper = \Core\Shipper\Models\Shipper::find(request()->shipper_id);
            }

            // get pickup addresses 
            if ((auth()->user() && auth()->user()->userable_type == 'shipper' && sizeof(request()->all()) == 0) ||
                (request()->shipper_id && sizeof(request()->all()) == 1)) {
                $builder->where('type', 'like', '%pickup%');
                
                if($shipper->contract) {
                    $builder->whereIn('city_id', $shipper->contract->items->pluck('from_city_id'));
                }
            }

            // get dropoff addresses
            if (request()->from_address_id) {
                $builder->where('type', 'like', '%dropoff%');

                if($shipper->contract) {
                    $from_city_id = Address::withoutGlobalScope(self::class)->find(request()->from_address_id)->city_id;

                    $builder->whereIn('city_id', $shipper->contract->items()
                                                                   ->where('from_city_id', $from_city_id)
                                                                   ->pluck('to_city_id'));
                }
            }
        }
    }
}