<?php

namespace Core\Common\Models;

use Core\Base\Models\Base;

class Company extends Base
{
    /**
     * Get the parent companyable model.
     */
    public function companyable()
    {
        return $this->morphTo();
    }

    /**
     * get file prefix.
     *
     * @return string
     */
    protected function getFilePrefix(): string
    {
        return request()->company ? 'company' : '';
    }

    /**
     * Set the logo.
     *
     * @param string $value
     */
    public function setLogoAttribute($value) : void
    {
        $this->setFilePath($value, 'logo', $this->getFilePrefix());
    }

    /**
     * get the logo.
     *
     * @param string $value
     */
    public function getLogoAttribute($value) : string
    {
        return $this->getFilePath($value);
    }

    /**
     * Set the cr copy.
     *
     * @param string $value
     */
    public function setCrCopyAttribute($value) : void
    {
        $this->setFilePath($value, 'cr_copy', $this->getFilePrefix());
    }

    /**
     * get the cr copy.
     *
     * @param string $value
     */
    public function getCrCopyAttribute($value) : string
    {
        return $this->getFilePath($value);
    }

    /**
     * Set the vat certificate copy.
     *
     * @param string $value
     */
    public function setVatCertificateCopyAttribute($value) : void
    {
        $this->setFilePath($value, 'vat_certificate_copy', $this->getFilePrefix());
    }

    /**
     * get the vat certificate copy.
     *
     * @param string $value
     */
    public function getVatCertificateCopyAttribute($value) : string
    {
        return $this->getFilePath($value);
    }

    /**
     * Set the iban certificate.
     *
     * @param string $value
     */
    public function setIbanCertificateAttribute($value) : void
    {
        $this->setFilePath($value, 'iban_certificate', $this->getFilePrefix());
    }

    /**
     * get the iban certificate.
     *
     * @param string $value
     */
    public function getIbanCertificateAttribute($value) : string
    {
        return $this->getFilePath($value);
    }
}
