<?php

namespace Core\Common\Models;

use Core\Base\Models\Base;

class City extends Base
{
    /**
     * get the state.
     */
    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    /**
     * get the addresses.
     */
    public function addresses()
    {
        return $this->hasMany(Address::class, 'city_id');
    }

    /**
     * get the contract items (from).
     */
    public function contractItemsFrom()
    {
        return $this->hasMany(\Core\Contract\Models\ContractItem::class, 'from_city_id');
    }

    /**
     * get the contract items (to).
     */
    public function contractItemsTo()
    {
        return $this->hasMany(\Core\Contract\Models\ContractItem::class, 'to_city_id');
    }

    /**
     * get shipments (from).
     */
    public function shipmentsFrom()
    {
        return $this->hasMany(\Core\Shipment\Models\Shipment::class, 'from_city_id');
    }

    /**
     * get shipments (to).
     */
    public function shipmentsTo()
    {
        return $this->hasMany(\Core\Shipment\Models\Shipment::class, 'to_city_id');
    }
}
