<?php

namespace Core\Common\Models;

use Core\Base\Models\Base;

class Attachment extends Base
{
    /**
     * Get the parent attachmentable model.
     */
    public function attachmentable()
    {
        return $this->morphTo();
    }

    /**
     * Set the path.
     *
     * @param string $value
     */
    public function setPathAttribute($value) : void
    {
        $attachment_name = $value;

        if (is_object($value)) {
            $extension       = $value->extension();
            $attachment_name = time() . '_' . md5(uniqid(rand(), true)) . '.' . $extension;
    
            $value->move(public_path('uploads/attachments'), $attachment_name);
        }

        $this->attributes['path'] = str_replace(url('/public/uploads/attachments') . '/', '', $attachment_name);
    }

    /**
     * get the path.
     *
     * @param string $value
     */
    public function getPathAttribute($value) : string
    {
        if(request()->route()->getName() == 'api.v1.orders.store') {
            return $value;
        }

        if(request()->method() == 'DELETE') {
            return public_path('uploads/attachments/' . $value);
        }

        return url('/public/uploads/attachments/' . $value);
    }

    /**
     *
     * @param  string $value
     */
    public function getDetailsAttribute($value) : array
    {
        return json_decode($value, true);
    }

    /**
     *
     * @param  array $value
     */
    public function setDetailsAttribute($value) : void
    {
        $this->attributes['details'] = json_encode($value ?? []);
    }
}
