<?php

namespace Core\Common\Models;

use Core\Base\Models\Base;

class Address extends Base
{
    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function booted()
    {
        static::addGlobalScope(new Scopes\RelatedAddressesScope);
    }

    /**
     * Get the parent addressable model.
     */
    public function addressable()
    {
        return $this->morphTo();
    }

    /**
     * get the city.
     */
    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }

    /**
     * get the pickup orders.
     */
    public function pickupOrders()
    {
        return $this->hasMany(\Core\Shipment\Models\Order::class, 'from_address_id');
    }

    /**
     * get the dropoff orders.
     */
    public function dropoffOrders()
    {
        return $this->hasMany(\Core\Shipment\Models\Order::class, 'to_address_id');
    }

    /**
     * get the phones.
     */
    public function phones()
    {
        return $this->morphMany(Phone::class, 'phoneable');
    }
}
