<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->morphs('companyable');
            $table->string('name')->nullable();
            $table->string('logo')->nullable();
            $table->string('cr_no')->nullable();
            $table->string('vat_registration_no')->nullable();
            $table->string('cr_copy')->nullable();
            $table->string('vat_certificate_copy')->nullable();
            $table->string('building_no')->nullable();
            $table->string('street_name')->nullable();
            $table->string('district_name')->nullable();
            $table->string('city_name')->nullable();
            $table->string('zip_code')->nullable();
            $table->string('additional_number')->nullable();
            $table->string('unit_number')->nullable();
            $table->string('iban_no')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('iban_certificate')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
