<?php

namespace Core\Common\Database\Factories;

use Core\Common\Models\State as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class StateFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $country = \Core\Common\Models\Country::factory()->create();
        return [
            'name' => $this->faker->text(100),
            'country_id' => $country->id,
            'fips_code' => $this->faker->text(100),
            'iso2' => $this->faker->text(100),
            'latitude' => $this->faker->randomFloat(),
            'longitude' => $this->faker->randomFloat(),
        ];
    }
}
