<?php

namespace Core\Common\Database\Factories;

use Core\Common\Models\Phone as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class PhoneFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'phoneable_type' => $this->faker->phoneNumber(),
            'phoneable_id'   => $this->faker->integer(),
            'type'           => $this->faker->text(100),
            'phone'          => $this->faker->phoneNumber(),
            'name'           => $this->faker->text(100),

        ];
    }
}
