<?php

namespace Core\Common\Database\Factories;

use Core\Common\Models\Country as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class CountryFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->text(100),
            'iso3' => $this->faker->word(),
            'iso2' => $this->faker->word(),
            'phonecode' => $this->faker->phoneNumber(),
            'capital' => $this->faker->text(100),
            'currency' => $this->faker->text(100),
            'currency_symbol' => $this->faker->text(100),
            'tld' => $this->faker->text(100),
            'native' => $this->faker->text(100),
            'region' => $this->faker->text(100),
            'subregion' => $this->faker->text(100),
            'timezones' => '',
            'translations' => '',
            'latitude' => $this->faker->randomFloat(),
            'longitude' => $this->faker->randomFloat(),
        ];
    }
}
