<?php

namespace Core\Common\Database\Factories;

use Core\Common\Models\Company as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class CompanyFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'companyable_type' => $this->faker->text(100),
            'companyable_id' => $this->faker->integer(),
            'name' => $this->faker->name,
            'logo' => $this->faker->text(100),
            'cr_no' => $this->faker->text(100),
            'vat_registration_no' => $this->faker->text(100),
            'cr_copy' => $this->faker->text(100),
            'vat_certificate_copy' => $this->faker->text(100),
            'building_no' => $this->faker->text(100),
            'street_name' => $this->faker->text(100),
            'district_name' => $this->faker->text(100),
            'city_name' => $this->faker->text(100),
            'zip_code' => $this->faker->text(100),
            'additional_number' => $this->faker->text(100),
            'unit_number' => $this->faker->text(100),
            'iban_no' => $this->faker->text(100),
            'bank_name' => $this->faker->text(100),
            'iban_certificate' => $this->faker->text(100),

        ];
    }
}
