<?php

namespace Core\Common\Database\Factories;

use Core\Common\Models\City as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class CityFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $state = \Core\Common\Models\State::factory()->create();
        return [
            'state_id' => $state->id,
            'name' => $this->faker->text(100),
            'name_ar' => $this->faker->text(100),
            'latitude' => $this->faker->randomFloat(),
            'longitude' => $this->faker->randomFloat(),
        ];
    }
}
