<?php

namespace Core\Common\Database\Factories;

use Core\Common\Models\Attachment as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class AttachmentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'attachmentable_type' => $this->faker->text(100),
            'attachmentable_id' => $this->faker->integer(),
            'label' => $this->faker->text(100),
            'path' => $this->faker->text(100),
            'details' => '',

        ];
    }
}
