<?php

namespace Core\Common\Database\Factories;

use Core\Common\Models\Address as Model;
use Illuminate\Database\Eloquent\Factories\Factory;

class AddressFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Model::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $city = \Core\Common\Models\City::factory()->create();
        return [
            'addressable_type' => $this->faker->randomElement(['group', 'shipper', 'provider', 'driver']),
            'addressable_id' => $this->faker->randomDigit(),
            'city_id' => $city->id,
            'name' => $this->faker->name,
            'type' => $this->faker->randomElement(['pickup', 'dropoff']),
            'address' => $this->faker->address(),
            'latitude' => $this->faker->latitude(),
            'longitude' => $this->faker->longitude(),
        ];
    }
}
