<?php

namespace Core\Common\Controllers\API\V1;

use Core\Common\Resources\NotificationResource as Resource;

class NotificationController extends \Core\Base\Controllers\API\Controller
{
    /**
     * Init.
     */
    public function __construct()
    {
        
    }

    /**
     * Get all the auth user notifications.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        return $this->sendResponse(Resource::collection(auth()->user()->unreadNotifications));
    }

    /**
     * Mark notification as read.
     *
     * @param  int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $notification = auth()->user()->unreadNotifications()->findOrFail($id);
        $notification->markAsRead();
        return $this->sendResponse(new Resource($notification), 'successfully marked as read.');
    }
}
