<?php

namespace Core\Common\Controllers\API\V1;

use Core\Common\Requests\CountryRequest as FormRequest;
use Core\Common\Models\Country as Model;
use Core\Common\Resources\CountryResource as Resource;

class CountryController extends \Core\Base\Controllers\API\Controller
{
    /**
     * Init.
     * @param FormRequest $request
     * @param Model       $model
     * @param string      $resource
     */
    public function __construct(FormRequest $request, Model $model, $resource = Resource::class)
    {
        parent::__construct($request, $model, $resource);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $response = [];

        /**
         * caching the data for now as the data is big (SQL query will be much better though)
         * at the first call it will take sometime (I'm using KSA and it takes AVG 50s)
         * after the caching, the response takes an AVG of 60ms
         */
        if ($this->request->cities) {
            set_time_limit(300);
            $response = cache()->remember("country-{$id}-with-cities", now()->addMonths(3), function () use ($id) {
                return (new $this->resource($this->model->find($id)))->response()->getData(true);
            });
        } else {
            $response = new $this->resource($this->model->find($id));
        }

        return $this->sendResponse($response);
    }
}
