<?php

namespace Core\Base\Traits\Model;

trait File
{
    /**
     * Set the file path.
     *
     * @param string $value
     * @param string $attribute
     * @param string $prefix
     */
    protected function setFilePath($value, $attribute, $prefix = '') : void
    {
        $file_attribute = empty($prefix) ? $attribute : "$prefix.$attribute";

        if (request()->file($file_attribute)) {
            try {
                $value           = request()->file($file_attribute);
                $extension       = $value->extension();
                $attachment_name = time() . '_' . md5(uniqid(rand(), true)) . '.' . $extension;
        
                $value->move(public_path('uploads/attachments'), $attachment_name);
    
                $this->attributes[$attribute] = $attachment_name;
            } catch (\Throwable $th) {
                //throw $th;
            }
        }
    }

    /**
     * get the file path.
     *
     * @param string $value
     */
    protected function getFilePath($value) : string
    {
        if(request()->method() == 'DELETE') {
            return public_path('uploads/attachments/' . $value);
        }

        return $value ? url('/public/uploads/attachments/' . $value) : '';
    }
}
