<?php

namespace Core\Base\Controllers\API;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class SystemController extends Controller
{
    /**
     * Init.
     * 
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * status of the system.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function status()
    {
        $is_success = true;

        DB::connection()->getPDO(); // throws exception and thus error response will be returned

        return $is_success ? $this->sendResponse() : $this->sendResponse([], 'Error.', false, 500);
    }

    /**
     * setup of the system.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function setup()
    {
        $data = [];

        if (Schema::hasTable('migrations')) {
            $data['new_setup'] = false;
            \Artisan::call('migrate');
        } else {
            $data['new_setup'] = true;
            \Artisan::call('key:generate');
            \Artisan::call('migrate --seed');
            \Artisan::call('passport:install --force');
        }

        return $this->sendResponse($data);
    }
}
