<?php

namespace Core\Base\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Schema;

class SystemSetup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'system:setup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Setup the system';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        if (Schema::hasTable('migrations')) {
            \Artisan::call('migrate');
        } else {
            \Artisan::call('key:generate');
            \Artisan::call('migrate --seed');
            \Artisan::call('passport:install --force');
        }
        
        return Command::SUCCESS;
    }
}
