<?php

Route::group(['prefix' => 'api', 'middleware' => []], function () {
    # V1
    Route::namespace('Core\Auth\Controllers\API\V1')->prefix('v1')->name('api.v1.')->group(function () {

        Route::post('auth/login', 'AuthController@login')->name('auth.login');
        Route::post('password/forgot', 'AuthController@sendResetLinkEmail');
        Route::post('password/reset', 'AuthController@resetPassword');

        Route::group(['middleware' => ['auth:api']], function () {
            #*** START: Auth ***#
            Route::group(['prefix' => 'auth'], function () {
                Route::post('logout', 'AuthController@logout');
                Route::put('update', 'AuthController@updateMe');
                Route::get('me', 'AuthController@me')->name('auth.me');
            });
            #*** END: Auth ***#
           
            Route::apiResource('users', 'UserController');
            Route::get('admins' , 'UserController@admins');


            
        });

    });
});
