<?php

namespace Core\Auth\Resources;

use Illuminate\Http\Resources\Json\JsonResource as Resource;
use Core\Provider\Resources\ProviderResource;
use Core\Provider\Resources\DriverResource;
use Core\Shipper\Resources\ShipperResource;
use Core\Financial\Resources\WalletResource;
use Core\Financial\Resources\AccountResource;
use Core\Financial\Resources\PromotionTrackerResource;

class UserResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $current_route = $request->route()->getName();

        return [
            'id'          => $this->id,
            'name'        => $this->name,
            'email'       => $this->email,
            'phone'       => $this->phone,
            'national_id' => $this->national_id,
            'avatar'      => $this->avatar,
            'type'        => $this->when($this->userable_type, $this->userable_type),
            'balance'     => $this->balance,
            'receive_sms_notifications' => $this->receive_sms_notifications,
            $this->mergeWhen($current_route == 'api.v1.users.show' || $current_route == 'api.v1.auth.me' || $current_route == 'api.v1.auth.login', [
                'provider' => $this->when($this->userable_type == 'provider', new ProviderResource($this->userable)),
                'driver'   => $this->when($this->userable_type == 'driver', new DriverResource($this->userable)),
                'shipper'  => $this->when($this->userable_type == 'shipper', new ShipperResource($this->userable)),
                'promotions_trackers' => PromotionTrackerResource::collection($this->promotionsTrackers)
            ]),
            $this->mergeWhen($current_route == 'api.v1.users.show' || $current_route == 'api.v1.auth.me' || $current_route == 'api.v1.auth.login' || $current_route == 'api.v1.providers.show' || $current_route == 'api.v1.shippers.show', [
                'wallet'  => new WalletResource($this->wallet),
                'account' => new AccountResource($this->account),
            ])
        ];
    }
}
