<?php

namespace Core\Auth\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE': {
                return [];
            }
            case 'POST': {
                return self::store();
            }
            case 'PUT': {
                return self::update();
            }
        }
    }

    /**
     * Get the validation rules that apply to the store request.
     *
     * @return array
     */
    public static function store()
    {
        return [
            'name' => 'string|required',
            'email' => 'string|unique:users|required',
            'password' => 'string|required',
            'userable_type' => 'nullable|in:provider,driver,shipper',
            'userable_id'   => 'required_with:userable_type',
        ];
    }

    /**
     * Get the validation rules that apply to the update request.
     *
     * @return array
     */
    public static function update()
    {
       
        return [
            'name' => 'string|nullable',
            'email' => 'string|nullable',
            'phone' => 'string|nullable',
            'password' => 'string|nullable',
            'userable_type' => 'nullable|in:provider,driver,shipper',
            'userable_id'   => 'required_with:userable_type',
        ];
    }
}
