<?php

namespace Core\Auth;

use Illuminate\Support\ServiceProvider;
use Core\Base\Traits\ServiceProvider\File;
use Illuminate\Database\Eloquent\Relations\Relation;
use Laravel\Passport\Console\ClientCommand;
use Laravel\Passport\Console\InstallCommand;
use Laravel\Passport\Console\KeysCommand;

class ModuleServiceProvider extends ServiceProvider
{
    use File;

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->loadFiles(__DIR__, 'auth');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        // to be able to use \Artisan::call('passport:install --force') for example from the controller
        $this->commands([
            InstallCommand::class,
            ClientCommand::class,
            KeysCommand::class,
        ]);

        Relation::enforceMorphMap([
            'user' => Models\User::class
        ]);

        Models\User::observe(Observers\UserObserver::class);
    }
}
