<?php

namespace Core\Auth\Controllers\API\V1;

use Core\Auth\Requests\UserRequest as FormRequest;
use Core\Auth\Models\User as Model;
use Core\Auth\Resources\UserResource as Resource;

class UserController extends \Core\Base\Controllers\API\Controller
{
    /**
     * Init.
     * @param FormRequest $request
     * @param Model       $model
     * @param string      $resource
     */
    public function __construct(FormRequest $request, Model $model, $resource = Resource::class)
    {
        parent::__construct($request, $model, $resource);
    }
    
    public function admins(){
        $admins = Model::where('userable_type', null)->get();
        return $this->sendResponse($admins);
        
    }
    
}
