### Getting started:
* You do not have a `.env` file in the project root directory so copy `.env.example` and save it as `.env`
* In `.env` file update the database info and the other credentials like `API_KEY`
* Open the terminal and navigate to the project directory and run `composer install`
* Generate the application key using `php artisan key:generate`
* Create the database tables by running `php artisan migrate --seed`
* Create the encryption keys needed to generate secure access tokens by running `php artisan passport:install`
* Download the Service Account JSON file (from Firebase) and rename it to this name `firebase-adminsdk.json`
* You will need to keep the `queue` running in the background, so this command needs to be always running `php artisan queue:work`
* To retry all of the failed jobs, execute `php artisan queue:retry all`
* enjoy 😃 !
### Notes:
* You can run the tests by running `php artisan test` (UI friendly) or `vendor/bin/phpunit`
* You can run **SonarQube** by copying `sonar-project.properties.example` and saving it as `sonar-project.properties` and then update all the info, and after that you can run the following:

```
sonar-scanner -Dsonar.login=token
```